﻿import mx.controls.Button;
import mx.controls.ComboBox;
import mx.controls.TextArea;
import mx.utils.Delegate;
import gfx.launchpanel.views.Dialog;
import gfx.launchpanel.views.BaseDialog;
import gfx.launchpanel.views.EditDialog;
import gfx.launchpanel.data.Profile;
import gfx.launchpanel.data.Player;
import com.gskinner.util.UserPreferences;

class gfx.launchpanel.Launcher extends MovieClip {
	// Static properties
	private static var SCRIPT_PATH:String = "Scaleform/jsfl/LaunchPanel.jsfl";	// PPS: Scaleform dir is where the extensions are installed on the user machine. Leave it alone.
	private static var SEP:String = "$__%__$";
	// Private properties
	private var so:SharedObject;
	private var lc:LocalConnection;
	private var playerList:Array;
	private var preferencesDelegate:Function;
	private var prefs:UserPreferences;
	
	// UI Elements
	private var publishBtn:Button;
	private var addProfileBtn:Button;
	private var removeProfileBtn:Button;
	private var editBtn:Button;
	private var players:ComboBox;
	private var profileList:ComboBox;
	private var addPlayerBtn:Button;
	private var removePlayerBtn:Button;
	private var settingsBtn:Button;	
	public var version:MovieClip;
	private var output:TextArea;
	private var dialog:Dialog;
	private var commands:String;
	private var profiles:Array;
	private var playersList:Array;
	private var editDialog
	private var selectedPlayer:Object;
	private var commandline:String;
	private var idealWidth:Number = 190;
	private var data:XML;
	private var itemsHash;
	public var LP_LBL_PROFILES:TextField;
	private var selectedProfile:Object;
	
	// Initialization
	public function Launcher() {
		so = SharedObject.getLocal("ScaleformLauncher");
		
	}
	private function onLoad():Void { configUI(); }
	
	// Private Methods
	private function configUI():Void {
		profiles = [];
		playersList = [];
		itemsHash = {};
		
		var language:String = checkLanguage();
		data = new XML();
		data.ignoreWhite = true;
		data.onLoad = Delegate.create(this, onDataLoaded);
		data.load('../Scaleform/locale/'+language+'/strings.xml');  // PPS: Scaleform dir is where the extensions are installed on the user machine. Leave it alone.
		
		publishBtn.addEventListener("click", Delegate.create(this, publish));	
		addProfileBtn.addEventListener("click", Delegate.create(this, onAddNewProfile));
		removeProfileBtn.addEventListener("click", Delegate.create(this, removeProfile));
		editBtn.addEventListener("click", Delegate.create(this, onEdit));
		profileList.addEventListener("change", Delegate.create(this,onProfileChange));

		profileList.rowCount = 3;
		
		profileList.labelField = 'name';
		players.labelField = 'name';
		
		var url:String = MMExecute('fl.configURI');
		url+='Scaleform/preferences/prefs';  // PPS: Scaleform dir is where the extensions are installed on the user machine. Leave it alone.
		prefs = new UserPreferences(url);
		editBtn.icon = 'ButtonIcon';
		
		checkPlayerPrefs();
		checkProfilePrefs();
		
		_global.style.setStyle("fontSize", 10);
		_global.style.setStyle("fontFamily", "Arial");
		_global.style.setStyle("themeColor", 0xAAAAAA);
		_global.style.setStyle("openDuration", 0);
		
		publishBtn.setStyle("fontSize", 12);
		publishBtn.setStyle("fontWeight", "bold");
		
		Stage.scaleMode = "noScale";
		Stage.align = "TL";
		Stage.addListener(this);
		onResize();

		lc = new LocalConnection();
		lc.connect("__ScaleformLauncher__");
		var owner = this;
		lc.publish = function() { owner.publish(); }
		
		var o:Object = {};
		o.onResize = Delegate.create(this, onUpdatePosition);
		Stage.addListener(o);
		
		preferencesDelegate = Delegate.create(this, submitPreferences);
		
		// SD:needed a delay to layout components
		this.onEnterFrame = function() {
			delete this.onEnterFrame;
			onUpdatePosition();
		}
	}
	
	private function checkLanguage():String {
		var lang:String = System.capabilities.language;
		// We only support english for now
		return "en";
	}
	
	private function onDataLoaded(p_value:Boolean):Void {
		var a:Array = data.firstChild.childNodes;
		
		for(var i:Number=0;i<a.length;i++) {
			var item = a[i];
			var key = item.attributes.key;
			var label = item.firstChild.nodeValue;
			if (!itemsHash[key]) {
				itemsHash[key] = label;
			}
			
		}
		LP_LBL_PROFILES.text = itemsHash['LP_LBL_PROFILES'];
	}
	
	private function onInfoClick(p_event:Object):Void {
		//trace('Enter');
	}
	
	private function onUpdatePosition():Void {
		var PADDING:Number = 2;
		var w:Number = Math.max(Stage.width-24,idealWidth);
		publishBtn.setSize(Stage.width-24,55);
		profileList.setSize(Stage.width-(addProfileBtn._width)-(removeProfileBtn._width)-(editBtn._width)-30,22);
		if (Stage.width-24 <= idealWidth) { 
			publishBtn.setSize(idealWidth,55);
			profileList.setSize(115,22);
			PADDING = 3;
		}
		
		addProfileBtn._x = profileList._x + profileList._width + PADDING;
		removeProfileBtn._x = addProfileBtn._x + addProfileBtn._width + PADDING;
		editBtn._x = removeProfileBtn._x + removeProfileBtn._width + PADDING;
		
		version._x = w + 20 - version._width;
	}
	
	private function onProfileChange(p_event:Object):Void {
		selectedProfile = profileList.selectedItem;
		so.data.lastSelected = profileList.selectedIndex;
		updateButton(profileList.getItemAt(profileList.selectedIndex).playerName);
		onUpdatePosition();
	}
	private function checkPlayerPrefs():Void {
		var p:Array = prefs.getPref('players');
		var l:Number = p.length;
		if (l == 0 || l == undefined) { 
			var player = new Player('[-- No Players Installed --]','');
			playersList.push(player);
			removeProfileBtn.enabled = editBtn.enabled = false;
			updateList('player');
			return;
		}
		loadPrefs('player',p,l);
		
	}
	private function checkProfilePrefs():Void {
		
		var p:Array = prefs.getPref('profiles');
		var l:Number = p.length;
		if (l == 0 || l == undefined) { 
			var profile = new Profile('Currently No Profiles','','');
			profiles.push(profile);
			updateList('profile');
			return;
		}
		loadPrefs('profile',p,l);
	}
	private function loadPrefs(p_type:String,p_data:Array,p_length:Number):Void {
		var l:Number = p_length;
		var p:Array = p_data;
		if (p_type == 'profile') {
			for (var i:Number=0;i<l;i++) {
				var command:String = p[i].command;
				var name:String = p[i].name;
				var path:String = p[i].playerPath;
				var playerName = p[i].playerName;
				var profile = new Profile(name,command,path,playerName);
				profiles.push(profile);
			}
		}else if(p_type == 'player') {
				for (var i:Number=0;i<l;i++) {
				var path:String = p[i].path;
				var name:String = p[i].name;
				var player = new Player(name,path);
				playersList.push(player);
			}
		}
		selectedProfile = profileList.selectedItem;
		updateList(p_type);
	}
	
	private function onAddNewProfile(p_evtObj:Object):Void {
		editDialog = Dialog.show("EditDialog",{title:"Edit Profile"});
		editDialog.addEventListener("edit", Delegate.create(this, saveProfile));
		editDialog.addEventListener("addPlayer", Delegate.create(this, addPlayer));
		editDialog.addEventListener("removePlayer",Delegate.create(this,removePlayer));
		this.onEnterFrame = function() {
			delete this.onEnterFrame;
			checkPlayerList();
			editDialog.loadPlayers(playersList);
		}
	}
	
	private function onEdit(p_evtObj:Object):Void {
		editDialog = Dialog.show("EditDialog",{title:"Edit Profile"});
		editDialog.addEventListener("edit", Delegate.create(this, editProfile));
		editDialog.addEventListener("addPlayer", Delegate.create(this, addPlayer));
		editDialog.addEventListener("removePlayer",Delegate.create(this,removePlayer));
		this.onEnterFrame = function() {
			delete this.onEnterFrame;
			checkPlayerList();
			editDialog.loadPlayers(playersList);
			selectedProfile = profiles[profileList.selectedIndex];
			editDialog.loadProfile(selectedProfile,itemsHash);
		}
	}
	
	private function editProfile(p_evtObj:Object):Void {
		var profile:Profile =  Profile(p_evtObj.profile);
		selectedProfile.command = profile.command;
		selectedProfile.playerPath = profile.playerPath;
		selectedProfile.name = profile.name;
		selectedProfile.playerName = profile.playerName;
		
		prefs.setPref('profiles',profiles,true);
		
		var item = profileList.selectedIndex;
		profileList.dataProvider = profiles.concat();
		profileList.selectedIndex = item;
		updateButton(selectedProfile.playerName);
		loadPrefs('profiles',profiles,profiles.length);
		onUpdatePosition();
	}
	
	private function addProfile(p_evtObj:Object):Void {
		var d:BaseDialog = Dialog.show("ProfileDialog", {title:"Save Profile"});
		d.addEventListener("save", Delegate.create(this,saveProfile));
	}
	
	private function checkPlayerList():Void {
		if ((playersList.length >1) && playersList[0].name == '[-- No Players Installed --]' ) {
			playersList.shift();
		}
	}
	
	private function saveProfile(p_evtObj:Object):Void {
		var profile:Profile =  Profile(p_evtObj.profile);
		profiles.push(profile);
		if (profiles[0].name == 'Currently No Profiles') { profiles.shift(); }
		prefs.setPref('profiles',profiles,true);
		updateList('profile','adding');
		onUpdatePosition();
	}
	
	private function removeProfile(p_evtObj:Object):Void {
		var response:String = runFunction("confirm", "Are you sure you want to remove the selected profile?");
		if (response != "true") { return; }
		var oldIndex:Number = profileList.selectedIndex;
		profiles.splice(profileList.selectedIndex,1);
		prefs.setPref('profiles',profiles,true);
		if (profiles.length == 0) {
			var profile = new Profile('Currently No Profiles','','');
			profiles.push(profile);
		}
		
		updateList('profile');
		onUpdatePosition();
	}
	
	private function updateList(p_type:String,p_option:String):Void {
		var playerName:String;
		switch(p_type) {
			case 'profile':
				profileList.dataProvider = profiles;
				selectedProfile = profileList.selectedIndex;
				if (so.data.lastSelected && p_option == undefined) { 
					profileList.selectedIndex = so.data.lastSelected; 
					playerName = profileList.selectedItem.playerName;
				}else {
					profileList.selectedIndex = profiles.length - 1;
					playerName = profileList.getItemAt(profileList.selectedIndex).playerName;
				}
				updateButton(playerName);
				break;
			case 'player': 
				players.dataProvider = playersList;
				players.selectedIndex = playersList.length-1;
			break;
		}
	}
	
	private function updateButton(p_player:String):Void {
		publishBtn.enabled = editBtn.enabled = (p_player == undefined  || p_player == '[-- No Players Installed --]') ? false : true;
		publishBtn.label = (publishBtn.enabled) ? 'Test with ' + p_player : '';
		publishBtn.setSize(Stage.width-20,35);
	}
				
	private function publish(p_evtObj:Object):Void {
		if (playerList.length == 0 || players.selectedItem.name == '[-- No Players Installed --]') {
			Dialog.show("AlertDialog", {title:"Error", message:"Please install a player first."});
			return;
		}
		so.data.lastSelected = profileList.selectedIndex;
		var command:String = selectedProfile.command;
		if (command == undefined) { command = profiles[profileList.selectedIndex].command; }
		runFunction("launchSWF",profileList.selectedItem.playerPath, command||"");
	}
	
	private function addPlayer(p_evtObj:Object):Void {
		var result:String = runFunction("selectPlayer");
		
		if (result == null) { return; }
		var parts:Array = result.split(SEP);
		if (parts[1] == null || parts[1] =="null" || parts[1].length == 0) { return; }
		var player:Player = new Player(parts[1],parts[0]);
		
		playersList.push(player);
		prefs.setPref('players',playersList,true);
		editDialog.update();
		updateUI();
		onUpdatePosition();
		players.dataProvider = playersList;
	}
	
	private function removePlayer(p_evtObj:Object):Void {
		var response:String = runFunction("confirm", "Are you sure you want to remove the selected player?");
		if (response != "true") { return; }
		var oldIndex:Number = players.selectedIndex;
		var removedItem = p_evtObj.removedPlayer;
		playersList.splice(removedItem, 1);
		prefs.setPref('players',playersList,true);
		updateList('players');
		editDialog.update();
		onUpdatePosition();
		updateUI();
	}
	
	private function updateUI():Void {
		publishBtn.enabled = removePlayerBtn.enabled = (playerList.length > 0);
		removeProfileBtn.enabled = (profileList.length == 0 || profileList.length == undefined) ? false:true;
		players.enabled = true;
		profileList.enabled = true;
		if (playerList.length == 0) {
			players.dataProvider = ["-- No Players Installed --"];
			players.enabled = false;
		}
	}
	private function onResize():Void {
		Dialog.setSize(Stage.width, Stage.height);
	}
	
	private function submitPreferences(p_evtObj:Object):Void {
		profileList.selectedItem.command = p_evtObj.data.commands
		commands = p_evtObj.data.commands;
		prefs.setPref('profiles',profiles,true);
	}
	
	// JSFL.  Move to JSFL class if it gets heavy
	private function runFunction():String {
		var params:Array = arguments;
		var functionName:String = params.shift().toString();		
		
		var args:Array = [];
		var l:Number = params.length;
		for (var i:Number=0; i<l; i++) {
			if (params[i] == undefined) { params[i] = ""; }
			args.push("'" + params[i].split("'").join("\'") + "'");
		}
		var scriptPath:String;
		if (params.length == 0) {
			scriptPath = "fl.runScript(fl.configURI + '"+SCRIPT_PATH+"', '"+functionName+"');";
		} else {
			scriptPath = "fl.runScript(fl.configURI + '"+SCRIPT_PATH+"', '"+functionName+"', "+args.join(",")+");";
		}
		return MMExecute(scriptPath);		
	}
}